/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl.krb5;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.net.ssl.SSLKeyException;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.ProtocolVersion;

final class KerberosPreMasterSecret {
    private ProtocolVersion protocolVersion;
    private byte[] preMaster;
    private byte[] encrypted;

    KerberosPreMasterSecret(ProtocolVersion protocolVersion, SecureRandom secureRandom, EncryptionKey encryptionKey) throws IOException {
        if (encryptionKey.getEType() == 16) {
            throw new IOException("session keys with des3-cbc-hmac-sha1-kd encryption type are not supported for TLS Kerberos cipher suites");
        }
        this.protocolVersion = protocolVersion;
        this.preMaster = KerberosPreMasterSecret.generatePreMaster(secureRandom, protocolVersion);
        try {
            EncryptedData encryptedData = new EncryptedData(encryptionKey, this.preMaster, 0);
            this.encrypted = encryptedData.getBytes();
        }
        catch (KrbException krbException) {
            throw (SSLKeyException)new SSLKeyException("Kerberos premaster secret error").initCause(krbException);
        }
    }

    KerberosPreMasterSecret(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, HandshakeInStream handshakeInStream, EncryptionKey encryptionKey) throws IOException {
        boolean bl;
        this.encrypted = handshakeInStream.getBytes16();
        if (HandshakeMessage.debug != null && Debug.isOn("handshake") && this.encrypted != null) {
            Debug.println(System.out, "encrypted premaster secret", this.encrypted);
        }
        if (encryptionKey.getEType() == 16) {
            throw new IOException("session keys with des3-cbc-hmac-sha1-kd encryption type are not supported for TLS Kerberos cipher suites");
        }
        try {
            EncryptedData encryptedData = new EncryptedData(encryptionKey.getEType(), null, this.encrypted);
            byte[] byArray = encryptedData.decrypt(encryptionKey, 0);
            if (HandshakeMessage.debug != null && Debug.isOn("handshake") && this.encrypted != null) {
                Debug.println(System.out, "decrypted premaster secret", byArray);
            }
            if (byArray.length == 52 && encryptedData.getEType() == 1) {
                if (KerberosPreMasterSecret.paddingByteIs(byArray, 52, (byte)4) || KerberosPreMasterSecret.paddingByteIs(byArray, 52, (byte)0)) {
                    byArray = Arrays.copyOf(byArray, 48);
                }
            } else if (byArray.length == 56 && encryptedData.getEType() == 3 && KerberosPreMasterSecret.paddingByteIs(byArray, 56, (byte)8)) {
                byArray = Arrays.copyOf(byArray, 48);
            }
            this.preMaster = byArray;
            this.protocolVersion = ProtocolVersion.valueOf(this.preMaster[0], this.preMaster[1]);
            if (HandshakeMessage.debug != null && Debug.isOn("handshake")) {
                System.out.println("Kerberos PreMasterSecret version: " + this.protocolVersion);
            }
        }
        catch (Exception exception) {
            this.preMaster = null;
            this.protocolVersion = protocolVersion;
        }
        boolean bl2 = bl = this.protocolVersion.v != protocolVersion2.v;
        if (bl && protocolVersion2.v <= 769) {
            boolean bl3 = bl = this.protocolVersion.v != protocolVersion.v;
        }
        if (this.preMaster == null || this.preMaster.length != 48 || bl) {
            if (HandshakeMessage.debug != null && Debug.isOn("handshake")) {
                System.out.println("Kerberos PreMasterSecret error, generating random secret");
                if (this.preMaster != null) {
                    Debug.println(System.out, "Invalid secret", this.preMaster);
                }
            }
            this.preMaster = KerberosPreMasterSecret.generatePreMaster(secureRandom, protocolVersion2);
            this.protocolVersion = protocolVersion2;
        }
    }

    private static boolean paddingByteIs(byte[] byArray, int n, byte by) {
        for (int i = 48; i < n; ++i) {
            if (byArray[i] == by) continue;
            return false;
        }
        return true;
    }

    KerberosPreMasterSecret(ProtocolVersion protocolVersion, SecureRandom secureRandom) {
        this.protocolVersion = protocolVersion;
        this.preMaster = KerberosPreMasterSecret.generatePreMaster(secureRandom, protocolVersion);
    }

    private static byte[] generatePreMaster(SecureRandom secureRandom, ProtocolVersion protocolVersion) {
        byte[] byArray = new byte[48];
        secureRandom.nextBytes(byArray);
        byArray[0] = protocolVersion.major;
        byArray[1] = protocolVersion.minor;
        return byArray;
    }

    byte[] getUnencrypted() {
        return this.preMaster;
    }

    byte[] getEncrypted() {
        return this.encrypted;
    }
}

