/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.tools;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXEventSerializer
extends DefaultHandler
implements LexicalHandler {
    private Writer _writer;
    private boolean _charactersAreCDATA;
    private StringBuffer _characters;
    private Stack _namespaceStack = new Stack();
    protected List _namespaceAttributes;

    public SAXEventSerializer(OutputStream outputStream) throws IOException {
        this._writer = new OutputStreamWriter(outputStream);
        this._charactersAreCDATA = false;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this._writer.write("<sax xmlns=\"http://www.sun.com/xml/sax-events\">\n");
            this._writer.write("<startDocument/>\n");
            this._writer.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this._writer.write("<endDocument/>\n");
            this._writer.write("</sax>");
            this._writer.flush();
            this._writer.close();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this._namespaceAttributes == null) {
            this._namespaceAttributes = new ArrayList();
        }
        String string3 = string.length() == 0 ? "xmlns" : "xmlns" + string;
        AttributeValueHolder attributeValueHolder = new AttributeValueHolder(string3, string, string2, null, null);
        this._namespaceAttributes.add(attributeValueHolder);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            int n;
            int n2;
            AttributeValueHolder[] attributeValueHolderArray;
            this.outputCharacters();
            if (this._namespaceAttributes != null) {
                attributeValueHolderArray = new AttributeValueHolder[]{};
                attributeValueHolderArray = this._namespaceAttributes.toArray(attributeValueHolderArray);
                this.quicksort(attributeValueHolderArray, 0, attributeValueHolderArray.length - 1);
                for (n2 = 0; n2 < attributeValueHolderArray.length; ++n2) {
                    this._writer.write("<startPrefixMapping prefix=\"" + attributeValueHolderArray[n2].localName + "\" uri=\"" + attributeValueHolderArray[n2].uri + "\"/>\n");
                    this._writer.flush();
                }
                this._namespaceStack.push(attributeValueHolderArray);
                this._namespaceAttributes = null;
            } else {
                this._namespaceStack.push(null);
            }
            attributeValueHolderArray = new AttributeValueHolder[attributes.getLength()];
            for (n2 = 0; n2 < attributes.getLength(); ++n2) {
                attributeValueHolderArray[n2] = new AttributeValueHolder(attributes.getQName(n2), attributes.getLocalName(n2), attributes.getURI(n2), attributes.getType(n2), attributes.getValue(n2));
            }
            this.quicksort(attributeValueHolderArray, 0, attributeValueHolderArray.length - 1);
            n2 = 0;
            for (n = 0; n < attributeValueHolderArray.length; ++n) {
                if (attributeValueHolderArray[n].uri.equals("http://www.w3.org/2000/xmlns/")) continue;
                ++n2;
            }
            if (n2 == 0) {
                this._writer.write("<startElement uri=\"" + string + "\" localName=\"" + string2 + "\" qName=\"" + string3 + "\"/>\n");
                return;
            }
            this._writer.write("<startElement uri=\"" + string + "\" localName=\"" + string2 + "\" qName=\"" + string3 + "\">\n");
            for (n = 0; n < attributeValueHolderArray.length; ++n) {
                if (attributeValueHolderArray[n].uri.equals("http://www.w3.org/2000/xmlns/")) continue;
                this._writer.write("  <attribute qName=\"" + attributeValueHolderArray[n].qName + "\" localName=\"" + attributeValueHolderArray[n].localName + "\" uri=\"" + attributeValueHolderArray[n].uri + "\" value=\"" + attributeValueHolderArray[n].value + "\"/>\n");
            }
            this._writer.write("</startElement>\n");
            this._writer.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.outputCharacters();
            this._writer.write("<endElement uri=\"" + string + "\" localName=\"" + string2 + "\" qName=\"" + string3 + "\"/>\n");
            this._writer.flush();
            AttributeValueHolder[] attributeValueHolderArray = (AttributeValueHolder[])this._namespaceStack.pop();
            if (attributeValueHolderArray != null) {
                for (int i = 0; i < attributeValueHolderArray.length; ++i) {
                    this._writer.write("<endPrefixMapping prefix=\"" + attributeValueHolderArray[i].localName + "\"/>\n");
                    this._writer.flush();
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0) {
            return;
        }
        if (this._characters == null) {
            this._characters = new StringBuffer();
        }
        this._characters.append(cArray, n, n2);
    }

    private void outputCharacters() throws SAXException {
        if (this._characters == null) {
            return;
        }
        try {
            this._writer.write("<characters>" + (this._charactersAreCDATA ? "<![CDATA[" : "") + this._characters + (this._charactersAreCDATA ? "]]>" : "") + "</characters>\n");
            this._writer.flush();
            this._characters = null;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            this.outputCharacters();
            this._writer.write("<processingInstruction target=\"" + string + "\" data=\"" + string2 + "\"/>\n");
            this._writer.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this._charactersAreCDATA = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this._charactersAreCDATA = false;
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.outputCharacters();
            this._writer.write("<comment>" + new String(cArray, n, n2) + "</comment>\n");
            this._writer.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void quicksort(AttributeValueHolder[] attributeValueHolderArray, int n, int n2) {
        while (n < n2) {
            int n3 = this.partition(attributeValueHolderArray, n, n2);
            this.quicksort(attributeValueHolderArray, n, n3);
            n = n3 + 1;
        }
    }

    private int partition(AttributeValueHolder[] attributeValueHolderArray, int n, int n2) {
        AttributeValueHolder attributeValueHolder = attributeValueHolderArray[n + n2 >>> 1];
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (attributeValueHolder.compareTo(attributeValueHolderArray[--n4]) < 0) {
                continue;
            }
            while (attributeValueHolder.compareTo(attributeValueHolderArray[++n3]) > 0) {
            }
            if (n3 >= n4) break;
            AttributeValueHolder attributeValueHolder2 = attributeValueHolderArray[n3];
            attributeValueHolderArray[n3] = attributeValueHolderArray[n4];
            attributeValueHolderArray[n4] = attributeValueHolder2;
        }
        return n4;
    }

    public static class AttributeValueHolder
    implements Comparable {
        public final String qName;
        public final String localName;
        public final String uri;
        public final String type;
        public final String value;

        public AttributeValueHolder(String string, String string2, String string3, String string4, String string5) {
            this.qName = string;
            this.localName = string2;
            this.uri = string3;
            this.type = string4;
            this.value = string5;
        }

        public int compareTo(Object object) {
            try {
                return this.qName.compareTo(((AttributeValueHolder)object).qName);
            }
            catch (Exception exception) {
                throw new RuntimeException(CommonResourceBundle.getInstance().getString("message.AttributeValueHolderExpected"));
            }
        }

        public boolean equals(Object object) {
            try {
                return object instanceof AttributeValueHolder && this.qName.equals(((AttributeValueHolder)object).qName);
            }
            catch (Exception exception) {
                throw new RuntimeException(CommonResourceBundle.getInstance().getString("message.AttributeValueHolderExpected"));
            }
        }

        public int hashCode() {
            int n = 7;
            n = 97 * n + (this.qName != null ? this.qName.hashCode() : 0);
            return n;
        }
    }
}

