/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.packaging.mime.internet;

import com.sun.xml.internal.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeBodyPart;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import javax.activation.DataSource;

public final class MimePartDataSource
implements DataSource {
    private final MimeBodyPart part;

    public MimePartDataSource(MimeBodyPart mimeBodyPart) {
        this.part = mimeBodyPart;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            InputStream inputStream = this.part.getContentStream();
            String string = this.part.getEncoding();
            if (string != null) {
                return MimeUtility.decode(inputStream, string);
            }
            return inputStream;
        }
        catch (MessagingException messagingException) {
            throw new IOException(messagingException.getMessage());
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }

    @Override
    public String getContentType() {
        return this.part.getContentType();
    }

    @Override
    public String getName() {
        try {
            return this.part.getFileName();
        }
        catch (MessagingException messagingException) {
            return "";
        }
    }
}

