/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.server;

import java.util.HashSet;
import java.util.Set;

public enum LazyMOMProvider {
    INSTANCE;

    private final Set<WSEndpointScopeChangeListener> endpointsWaitingForMOM = new HashSet<WSEndpointScopeChangeListener>();
    private final Set<DefaultScopeChangeListener> listeners = new HashSet<DefaultScopeChangeListener>();
    private volatile Scope scope = Scope.STANDALONE;

    public void initMOMForScope(Scope scope) {
        if (this.scope == Scope.GLASSFISH_JMX || scope == Scope.STANDALONE && (this.scope == Scope.GLASSFISH_JMX || this.scope == Scope.GLASSFISH_NO_JMX) || this.scope == scope) {
            return;
        }
        this.scope = scope;
        this.fireScopeChanged();
    }

    private void fireScopeChanged() {
        for (ScopeChangeListener scopeChangeListener : this.endpointsWaitingForMOM) {
            scopeChangeListener.scopeChanged(this.scope);
        }
        for (ScopeChangeListener scopeChangeListener : this.listeners) {
            scopeChangeListener.scopeChanged(this.scope);
        }
    }

    public void registerListener(DefaultScopeChangeListener defaultScopeChangeListener) {
        this.listeners.add(defaultScopeChangeListener);
        if (!this.isProviderInDefaultScope()) {
            defaultScopeChangeListener.scopeChanged(this.scope);
        }
    }

    private boolean isProviderInDefaultScope() {
        return this.scope == Scope.STANDALONE;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void registerEndpoint(WSEndpointScopeChangeListener wSEndpointScopeChangeListener) {
        this.endpointsWaitingForMOM.add(wSEndpointScopeChangeListener);
        if (!this.isProviderInDefaultScope()) {
            wSEndpointScopeChangeListener.scopeChanged(this.scope);
        }
    }

    public void unregisterEndpoint(WSEndpointScopeChangeListener wSEndpointScopeChangeListener) {
        this.endpointsWaitingForMOM.remove(wSEndpointScopeChangeListener);
    }

    public static interface DefaultScopeChangeListener
    extends ScopeChangeListener {
    }

    public static enum Scope {
        STANDALONE,
        GLASSFISH_NO_JMX,
        GLASSFISH_JMX;

    }

    public static interface ScopeChangeListener {
        public void scopeChanged(Scope var1);
    }

    public static interface WSEndpointScopeChangeListener
    extends ScopeChangeListener {
    }
}

