/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.dump;

import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.commons.xmlutil.Converter;
import com.sun.xml.internal.ws.dump.MessageDumper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingDumpTube
extends AbstractFilterTubeImpl {
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    private MessageDumper messageDumper;
    private final Level loggingLevel;
    private final Position position;
    private final int tubeId;

    public LoggingDumpTube(Level level, Position position, Tube tube) {
        super(tube);
        this.position = position;
        this.loggingLevel = level;
        this.tubeId = ID_GENERATOR.incrementAndGet();
    }

    public void setLoggedTubeName(String string) {
        assert (this.messageDumper == null);
        this.messageDumper = new MessageDumper(string, Logger.getLogger(string), this.loggingLevel);
    }

    private LoggingDumpTube(LoggingDumpTube loggingDumpTube, TubeCloner tubeCloner) {
        super(loggingDumpTube, tubeCloner);
        this.messageDumper = loggingDumpTube.messageDumper;
        this.loggingLevel = loggingDumpTube.loggingLevel;
        this.position = loggingDumpTube.position;
        this.tubeId = ID_GENERATOR.incrementAndGet();
    }

    @Override
    public LoggingDumpTube copy(TubeCloner tubeCloner) {
        return new LoggingDumpTube(this, tubeCloner);
    }

    @Override
    public NextAction processRequest(Packet packet) {
        if (this.messageDumper.isLoggable()) {
            Packet packet2 = packet != null ? packet.copy(true) : null;
            this.messageDumper.dump(MessageDumper.MessageType.Request, this.position.requestState, Converter.toString(packet2), this.tubeId, Fiber.current().owner.id);
        }
        return super.processRequest(packet);
    }

    @Override
    public NextAction processResponse(Packet packet) {
        if (this.messageDumper.isLoggable()) {
            Packet packet2 = packet != null ? packet.copy(true) : null;
            this.messageDumper.dump(MessageDumper.MessageType.Response, this.position.responseState, Converter.toString(packet2), this.tubeId, Fiber.current().owner.id);
        }
        return super.processResponse(packet);
    }

    @Override
    public NextAction processException(Throwable throwable) {
        if (this.messageDumper.isLoggable()) {
            this.messageDumper.dump(MessageDumper.MessageType.Exception, this.position.responseState, Converter.toString(throwable), this.tubeId, Fiber.current().owner.id);
        }
        return super.processException(throwable);
    }

    @Override
    public void preDestroy() {
        super.preDestroy();
    }

    public static enum Position {
        Before(MessageDumper.ProcessingState.Received, MessageDumper.ProcessingState.Processed),
        After(MessageDumper.ProcessingState.Processed, MessageDumper.ProcessingState.Received);

        private final MessageDumper.ProcessingState requestState;
        private final MessageDumper.ProcessingState responseState;

        private Position(MessageDumper.ProcessingState processingState, MessageDumper.ProcessingState processingState2) {
            this.requestState = processingState;
            this.responseState = processingState2;
        }
    }
}

