/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.handler.HandlerTube;
import com.sun.xml.internal.ws.handler.MessageUpdatableContext;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;

abstract class HandlerProcessor<C extends MessageUpdatableContext> {
    boolean isClient;
    static final Logger logger = Logger.getLogger("com.sun.xml.internal.ws.handler");
    private List<? extends Handler> handlers;
    WSBinding binding;
    private int index = -1;
    private HandlerTube owner;

    protected HandlerProcessor(HandlerTube handlerTube, WSBinding wSBinding, List<? extends Handler> list) {
        this.owner = handlerTube;
        if (list == null) {
            list = new ArrayList<Handler>();
        }
        this.handlers = list;
        this.binding = wSBinding;
    }

    int getIndex() {
        return this.index;
    }

    void setIndex(int n) {
        this.index = n;
    }

    public boolean callHandlersRequest(Direction direction, C c, boolean bl) {
        boolean bl2;
        this.setDirection(direction, c);
        try {
            bl2 = direction == Direction.OUTBOUND ? this.callHandleMessage(c, 0, this.handlers.size() - 1) : this.callHandleMessage(c, this.handlers.size() - 1, 0);
        }
        catch (ProtocolException protocolException) {
            logger.log(Level.FINER, "exception in handler chain", protocolException);
            if (bl) {
                this.insertFaultMessage(c, protocolException);
                this.reverseDirection(direction, c);
                this.setHandleFaultProperty();
                if (direction == Direction.OUTBOUND) {
                    this.callHandleFault(c, this.getIndex() - 1, 0);
                } else {
                    this.callHandleFault(c, this.getIndex() + 1, this.handlers.size() - 1);
                }
                return false;
            }
            throw protocolException;
        }
        catch (RuntimeException runtimeException) {
            logger.log(Level.FINER, "exception in handler chain", runtimeException);
            throw runtimeException;
        }
        if (!bl2) {
            if (bl) {
                this.reverseDirection(direction, c);
                if (direction == Direction.OUTBOUND) {
                    this.callHandleMessageReverse(c, this.getIndex() - 1, 0);
                } else {
                    this.callHandleMessageReverse(c, this.getIndex() + 1, this.handlers.size() - 1);
                }
            } else {
                this.setHandleFalseProperty();
            }
            return false;
        }
        return bl2;
    }

    public void callHandlersResponse(Direction direction, C c, boolean bl) {
        this.setDirection(direction, c);
        try {
            if (bl) {
                if (direction == Direction.OUTBOUND) {
                    this.callHandleFault(c, 0, this.handlers.size() - 1);
                } else {
                    this.callHandleFault(c, this.handlers.size() - 1, 0);
                }
            } else if (direction == Direction.OUTBOUND) {
                this.callHandleMessageReverse(c, 0, this.handlers.size() - 1);
            } else {
                this.callHandleMessageReverse(c, this.handlers.size() - 1, 0);
            }
        }
        catch (RuntimeException runtimeException) {
            logger.log(Level.FINER, "exception in handler chain", runtimeException);
            throw runtimeException;
        }
    }

    private void reverseDirection(Direction direction, C c) {
        if (direction == Direction.OUTBOUND) {
            ((MessageUpdatableContext)c).put("javax.xml.ws.handler.message.outbound", (Object)false);
        } else {
            ((MessageUpdatableContext)c).put("javax.xml.ws.handler.message.outbound", (Object)true);
        }
    }

    private void setDirection(Direction direction, C c) {
        if (direction == Direction.OUTBOUND) {
            ((MessageUpdatableContext)c).put("javax.xml.ws.handler.message.outbound", (Object)true);
        } else {
            ((MessageUpdatableContext)c).put("javax.xml.ws.handler.message.outbound", (Object)false);
        }
    }

    private void setHandleFaultProperty() {
        this.owner.setHandleFault();
    }

    private void setHandleFalseProperty() {
        this.owner.setHandleFalse();
    }

    abstract void insertFaultMessage(C var1, ProtocolException var2);

    private boolean callHandleMessage(C c, int n, int n2) {
        int n3;
        try {
            if (n > n2) {
                for (n3 = n; n3 >= n2; --n3) {
                    if (this.handlers.get(n3).handleMessage(c)) continue;
                    this.setIndex(n3);
                    return false;
                }
            } else {
                while (n3 <= n2) {
                    if (!this.handlers.get(n3).handleMessage(c)) {
                        this.setIndex(n3);
                        return false;
                    }
                    ++n3;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.setIndex(n3);
            throw runtimeException;
        }
        return true;
    }

    private boolean callHandleMessageReverse(C c, int n, int n2) {
        int n3;
        if (this.handlers.isEmpty() || n == -1 || n == this.handlers.size()) {
            return false;
        }
        if (n > n2) {
            for (n3 = n; n3 >= n2; --n3) {
                if (this.handlers.get(n3).handleMessage(c)) continue;
                this.setHandleFalseProperty();
                return false;
            }
        } else {
            while (n3 <= n2) {
                if (!this.handlers.get(n3).handleMessage(c)) {
                    this.setHandleFalseProperty();
                    return false;
                }
                ++n3;
            }
        }
        return true;
    }

    private boolean callHandleFault(C c, int n, int n2) {
        int n3;
        if (this.handlers.isEmpty() || n == -1 || n == this.handlers.size()) {
            return false;
        }
        if (n > n2) {
            try {
                for (n3 = n; n3 >= n2; --n3) {
                    if (this.handlers.get(n3).handleFault(c)) continue;
                    return false;
                }
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.FINER, "exception in handler chain", runtimeException);
                throw runtimeException;
            }
        }
        try {
            while (n3 <= n2) {
                if (!this.handlers.get(n3).handleFault(c)) {
                    return false;
                }
                ++n3;
            }
        }
        catch (RuntimeException runtimeException) {
            logger.log(Level.FINER, "exception in handler chain", runtimeException);
            throw runtimeException;
        }
        return true;
    }

    void closeHandlers(MessageContext messageContext, int n, int n2) {
        if (this.handlers.isEmpty() || n == -1) {
            return;
        }
        if (n > n2) {
            for (int i = n; i >= n2; --i) {
                try {
                    this.handlers.get(i).close(messageContext);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    logger.log(Level.INFO, "Exception ignored during close", runtimeException);
                }
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                try {
                    this.handlers.get(i).close(messageContext);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    logger.log(Level.INFO, "Exception ignored during close", runtimeException);
                }
            }
        }
    }

    public static enum Direction {
        OUTBOUND,
        INBOUND;

    }

    public static enum RequestOrResponse {
        REQUEST,
        RESPONSE;

    }
}

