/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.xml.internal.ws.resources.HttpserverMessages;
import com.sun.xml.internal.ws.transport.http.HttpAdapter;
import com.sun.xml.internal.ws.transport.http.server.ServerConnectionImpl;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

final class WSHttpHandler
implements HttpHandler {
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String HEAD_METHOD = "HEAD";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final Logger LOGGER = Logger.getLogger("com.sun.xml.internal.ws.server.http");
    private static final boolean fineTraceEnabled = LOGGER.isLoggable(Level.FINE);
    private final HttpAdapter adapter;
    private final Executor executor;

    public WSHttpHandler(@NotNull HttpAdapter httpAdapter, @Nullable Executor executor) {
        assert (httpAdapter != null);
        this.adapter = httpAdapter;
        this.executor = executor;
    }

    @Override
    public void handle(HttpExchange httpExchange) {
        try {
            if (fineTraceEnabled) {
                LOGGER.log(Level.FINE, "Received HTTP request:{0}", httpExchange.getRequestURI());
            }
            if (this.executor != null) {
                this.executor.execute(new HttpHandlerRunnable(httpExchange));
            } else {
                this.handleExchange(httpExchange);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExchange(HttpExchange httpExchange) throws IOException {
        ServerConnectionImpl serverConnectionImpl = new ServerConnectionImpl(this.adapter, httpExchange);
        try {
            String string;
            if (fineTraceEnabled) {
                LOGGER.log(Level.FINE, "Received HTTP request:{0}", httpExchange.getRequestURI());
            }
            if ((string = httpExchange.getRequestMethod()).equals(GET_METHOD) || string.equals(POST_METHOD) || string.equals(HEAD_METHOD) || string.equals(PUT_METHOD) || string.equals(DELETE_METHOD)) {
                this.adapter.handle(serverConnectionImpl);
            } else if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(HttpserverMessages.UNEXPECTED_HTTP_METHOD(string));
            }
        }
        finally {
            httpExchange.close();
        }
    }

    class HttpHandlerRunnable
    implements Runnable {
        final HttpExchange msg;

        HttpHandlerRunnable(HttpExchange httpExchange) {
            this.msg = httpExchange;
        }

        @Override
        public void run() {
            try {
                WSHttpHandler.this.handleExchange(this.msg);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

