/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BinaryOperator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;

class ArrayPrefixHelpers {
    static final int CUMULATE = 1;
    static final int SUMMED = 2;
    static final int FINISHED = 4;
    static final int MIN_PARTITION = 16;

    private ArrayPrefixHelpers() {
    }

    static final class CumulateTask<T>
    extends CountedCompleter<Void> {
        final T[] array;
        final BinaryOperator<T> function;
        CumulateTask<T> left;
        CumulateTask<T> right;
        T in;
        T out;
        final int lo;
        final int hi;
        final int origin;
        final int fence;
        final int threshold;

        public CumulateTask(CumulateTask<T> cumulateTask, BinaryOperator<T> binaryOperator, T[] TArray, int n, int n2) {
            super(cumulateTask);
            this.function = binaryOperator;
            this.array = TArray;
            this.lo = this.origin = n;
            this.hi = this.fence = n2;
            int n3 = (n2 - n) / (ForkJoinPool.getCommonPoolParallelism() << 3);
            this.threshold = n3 <= 16 ? 16 : n3;
        }

        CumulateTask(CumulateTask<T> cumulateTask, BinaryOperator<T> binaryOperator, T[] TArray, int n, int n2, int n3, int n4, int n5) {
            super(cumulateTask);
            this.function = binaryOperator;
            this.array = TArray;
            this.origin = n;
            this.fence = n2;
            this.threshold = n3;
            this.lo = n4;
            this.hi = n5;
        }

        @Override
        public final void compute() {
            int n;
            int n2;
            T[] TArray;
            BinaryOperator<T> binaryOperator;
            block26: {
                block25: {
                    binaryOperator = this.function;
                    if (binaryOperator == null) break block25;
                    TArray = this.array;
                    if (this.array != null) break block26;
                }
                throw new NullPointerException();
            }
            int n3 = this.threshold;
            int n4 = this.origin;
            int n5 = this.fence;
            CumulateTask cumulateTask = this;
            block0: while ((n2 = cumulateTask.lo) >= 0 && (n = cumulateTask.hi) <= TArray.length) {
                int n6;
                int n7;
                int n8;
                if (n - n2 > n3) {
                    CumulateTask cumulateTask2;
                    CumulateTask cumulateTask3 = cumulateTask.left;
                    CumulateTask<T> cumulateTask4 = cumulateTask.right;
                    if (cumulateTask3 == null) {
                        n8 = n2 + n >>> 1;
                        cumulateTask.right = new CumulateTask(cumulateTask, binaryOperator, TArray, n4, n5, n3, n8, n);
                        cumulateTask4 = cumulateTask.right;
                        cumulateTask2 = cumulateTask.right;
                        cumulateTask.left = new CumulateTask<T>(cumulateTask, binaryOperator, TArray, n4, n5, n3, n2, n8);
                        cumulateTask3 = cumulateTask.left;
                        cumulateTask = cumulateTask.left;
                    } else {
                        T t;
                        cumulateTask3.in = t = cumulateTask.in;
                        cumulateTask = null;
                        cumulateTask2 = null;
                        if (cumulateTask4 != null) {
                            int n9;
                            T t2 = cumulateTask3.out;
                            Object object = cumulateTask4.in = n2 == n4 ? t2 : binaryOperator.apply(t, t2);
                            while (((n9 = cumulateTask4.getPendingCount()) & 1) == 0) {
                                if (!cumulateTask4.compareAndSetPendingCount(n9, n9 | 1)) continue;
                                cumulateTask = cumulateTask4;
                                break;
                            }
                        }
                        while (((n7 = cumulateTask3.getPendingCount()) & 1) == 0) {
                            if (!cumulateTask3.compareAndSetPendingCount(n7, n7 | 1)) continue;
                            if (cumulateTask != null) {
                                cumulateTask2 = cumulateTask;
                            }
                            cumulateTask = cumulateTask3;
                            break;
                        }
                        if (cumulateTask == null) break;
                    }
                    if (cumulateTask2 == null) continue;
                    cumulateTask2.fork();
                    continue;
                }
                while (((n6 = cumulateTask.getPendingCount()) & 4) == 0) {
                    Object object;
                    int n10 = (n6 & 1) != 0 ? 4 : (n2 > n4 ? 2 : 6);
                    if (!cumulateTask.compareAndSetPendingCount(n6, n6 | n10)) continue;
                    if (n10 != 2) {
                        int n11;
                        if (n2 == n4) {
                            object = TArray[n4];
                            n11 = n4 + 1;
                        } else {
                            object = cumulateTask.in;
                            n11 = n2;
                        }
                        for (n8 = n11; n8 < n; ++n8) {
                            object = binaryOperator.apply(object, TArray[n8]);
                            TArray[n8] = object;
                        }
                    } else if (n < n5) {
                        object = TArray[n2];
                        for (int i = n2 + 1; i < n; ++i) {
                            object = binaryOperator.apply(object, TArray[i]);
                        }
                    } else {
                        object = cumulateTask.in;
                    }
                    cumulateTask.out = object;
                    while (true) {
                        CumulateTask cumulateTask5;
                        if ((cumulateTask5 = (CumulateTask)cumulateTask.getCompleter()) == null) {
                            if ((n10 & 4) == 0) break block0;
                            cumulateTask.quietlyComplete();
                            break block0;
                        }
                        n8 = cumulateTask5.getPendingCount();
                        if ((n8 & n10 & 4) != 0) {
                            cumulateTask = cumulateTask5;
                            continue;
                        }
                        if ((n8 & n10 & 2) != 0) {
                            int n12;
                            CumulateTask<T> cumulateTask6;
                            CumulateTask<T> cumulateTask7 = cumulateTask5.left;
                            if (cumulateTask7 != null && (cumulateTask6 = cumulateTask5.right) != null) {
                                T t = cumulateTask7.out;
                                cumulateTask5.out = cumulateTask6.hi == n5 ? t : binaryOperator.apply(t, cumulateTask6.out);
                            }
                            if ((n7 = n8 | n10 | (n12 = (n8 & 1) == 0 && cumulateTask5.lo == n4 ? 1 : 0)) != n8 && !cumulateTask5.compareAndSetPendingCount(n8, n7)) continue;
                            n10 = 2;
                            cumulateTask = cumulateTask5;
                            if (n12 == 0) continue;
                            cumulateTask5.fork();
                            continue;
                        }
                        if (cumulateTask5.compareAndSetPendingCount(n8, n8 | n10)) break;
                    }
                    break block0;
                }
                break block0;
            }
        }
    }

    static final class DoubleCumulateTask
    extends CountedCompleter<Void> {
        final double[] array;
        final DoubleBinaryOperator function;
        DoubleCumulateTask left;
        DoubleCumulateTask right;
        double in;
        double out;
        final int lo;
        final int hi;
        final int origin;
        final int fence;
        final int threshold;

        public DoubleCumulateTask(DoubleCumulateTask doubleCumulateTask, DoubleBinaryOperator doubleBinaryOperator, double[] dArray, int n, int n2) {
            super(doubleCumulateTask);
            this.function = doubleBinaryOperator;
            this.array = dArray;
            this.lo = this.origin = n;
            this.hi = this.fence = n2;
            int n3 = (n2 - n) / (ForkJoinPool.getCommonPoolParallelism() << 3);
            this.threshold = n3 <= 16 ? 16 : n3;
        }

        DoubleCumulateTask(DoubleCumulateTask doubleCumulateTask, DoubleBinaryOperator doubleBinaryOperator, double[] dArray, int n, int n2, int n3, int n4, int n5) {
            super(doubleCumulateTask);
            this.function = doubleBinaryOperator;
            this.array = dArray;
            this.origin = n;
            this.fence = n2;
            this.threshold = n3;
            this.lo = n4;
            this.hi = n5;
        }

        @Override
        public final void compute() {
            int n;
            int n2;
            double[] dArray;
            DoubleBinaryOperator doubleBinaryOperator;
            block26: {
                block25: {
                    doubleBinaryOperator = this.function;
                    if (doubleBinaryOperator == null) break block25;
                    dArray = this.array;
                    if (this.array != null) break block26;
                }
                throw new NullPointerException();
            }
            int n3 = this.threshold;
            int n4 = this.origin;
            int n5 = this.fence;
            DoubleCumulateTask doubleCumulateTask = this;
            block0: while ((n2 = doubleCumulateTask.lo) >= 0 && (n = doubleCumulateTask.hi) <= dArray.length) {
                int n6;
                int n7;
                int n8;
                if (n - n2 > n3) {
                    DoubleCumulateTask doubleCumulateTask2;
                    DoubleCumulateTask doubleCumulateTask3 = doubleCumulateTask.left;
                    DoubleCumulateTask doubleCumulateTask4 = doubleCumulateTask.right;
                    if (doubleCumulateTask3 == null) {
                        n8 = n2 + n >>> 1;
                        doubleCumulateTask4 = doubleCumulateTask.right = new DoubleCumulateTask(doubleCumulateTask, doubleBinaryOperator, dArray, n4, n5, n3, n8, n);
                        doubleCumulateTask2 = doubleCumulateTask.right;
                        doubleCumulateTask3 = doubleCumulateTask.left = new DoubleCumulateTask(doubleCumulateTask, doubleBinaryOperator, dArray, n4, n5, n3, n2, n8);
                        doubleCumulateTask = doubleCumulateTask.left;
                    } else {
                        double d;
                        doubleCumulateTask3.in = d = doubleCumulateTask.in;
                        doubleCumulateTask = null;
                        doubleCumulateTask2 = null;
                        if (doubleCumulateTask4 != null) {
                            int n9;
                            double d2 = doubleCumulateTask3.out;
                            double d3 = doubleCumulateTask4.in = n2 == n4 ? d2 : doubleBinaryOperator.applyAsDouble(d, d2);
                            while (((n9 = doubleCumulateTask4.getPendingCount()) & 1) == 0) {
                                if (!doubleCumulateTask4.compareAndSetPendingCount(n9, n9 | 1)) continue;
                                doubleCumulateTask = doubleCumulateTask4;
                                break;
                            }
                        }
                        while (((n7 = doubleCumulateTask3.getPendingCount()) & 1) == 0) {
                            if (!doubleCumulateTask3.compareAndSetPendingCount(n7, n7 | 1)) continue;
                            if (doubleCumulateTask != null) {
                                doubleCumulateTask2 = doubleCumulateTask;
                            }
                            doubleCumulateTask = doubleCumulateTask3;
                            break;
                        }
                        if (doubleCumulateTask == null) break;
                    }
                    if (doubleCumulateTask2 == null) continue;
                    doubleCumulateTask2.fork();
                    continue;
                }
                while (((n6 = doubleCumulateTask.getPendingCount()) & 4) == 0) {
                    int n10;
                    double d;
                    int n11 = (n6 & 1) != 0 ? 4 : (n2 > n4 ? 2 : 6);
                    if (!doubleCumulateTask.compareAndSetPendingCount(n6, n6 | n11)) continue;
                    if (n11 != 2) {
                        if (n2 == n4) {
                            d = dArray[n4];
                            n8 = n4 + 1;
                        } else {
                            d = doubleCumulateTask.in;
                            n8 = n2;
                        }
                        for (n10 = n8; n10 < n; ++n10) {
                            dArray[n10] = d = doubleBinaryOperator.applyAsDouble(d, dArray[n10]);
                        }
                    } else if (n < n5) {
                        d = dArray[n2];
                        for (n8 = n2 + 1; n8 < n; ++n8) {
                            d = doubleBinaryOperator.applyAsDouble(d, dArray[n8]);
                        }
                    } else {
                        d = doubleCumulateTask.in;
                    }
                    doubleCumulateTask.out = d;
                    while (true) {
                        DoubleCumulateTask doubleCumulateTask5;
                        if ((doubleCumulateTask5 = (DoubleCumulateTask)doubleCumulateTask.getCompleter()) == null) {
                            if ((n11 & 4) == 0) break block0;
                            doubleCumulateTask.quietlyComplete();
                            break block0;
                        }
                        n10 = doubleCumulateTask5.getPendingCount();
                        if ((n10 & n11 & 4) != 0) {
                            doubleCumulateTask = doubleCumulateTask5;
                            continue;
                        }
                        if ((n10 & n11 & 2) != 0) {
                            int n12;
                            DoubleCumulateTask doubleCumulateTask6;
                            DoubleCumulateTask doubleCumulateTask7 = doubleCumulateTask5.left;
                            if (doubleCumulateTask7 != null && (doubleCumulateTask6 = doubleCumulateTask5.right) != null) {
                                double d4 = doubleCumulateTask7.out;
                                doubleCumulateTask5.out = doubleCumulateTask6.hi == n5 ? d4 : doubleBinaryOperator.applyAsDouble(d4, doubleCumulateTask6.out);
                            }
                            if ((n7 = n10 | n11 | (n12 = (n10 & 1) == 0 && doubleCumulateTask5.lo == n4 ? 1 : 0)) != n10 && !doubleCumulateTask5.compareAndSetPendingCount(n10, n7)) continue;
                            n11 = 2;
                            doubleCumulateTask = doubleCumulateTask5;
                            if (n12 == 0) continue;
                            doubleCumulateTask5.fork();
                            continue;
                        }
                        if (doubleCumulateTask5.compareAndSetPendingCount(n10, n10 | n11)) break;
                    }
                    break block0;
                }
                break block0;
            }
        }
    }

    static final class IntCumulateTask
    extends CountedCompleter<Void> {
        final int[] array;
        final IntBinaryOperator function;
        IntCumulateTask left;
        IntCumulateTask right;
        int in;
        int out;
        final int lo;
        final int hi;
        final int origin;
        final int fence;
        final int threshold;

        public IntCumulateTask(IntCumulateTask intCumulateTask, IntBinaryOperator intBinaryOperator, int[] nArray, int n, int n2) {
            super(intCumulateTask);
            this.function = intBinaryOperator;
            this.array = nArray;
            this.lo = this.origin = n;
            this.hi = this.fence = n2;
            int n3 = (n2 - n) / (ForkJoinPool.getCommonPoolParallelism() << 3);
            this.threshold = n3 <= 16 ? 16 : n3;
        }

        IntCumulateTask(IntCumulateTask intCumulateTask, IntBinaryOperator intBinaryOperator, int[] nArray, int n, int n2, int n3, int n4, int n5) {
            super(intCumulateTask);
            this.function = intBinaryOperator;
            this.array = nArray;
            this.origin = n;
            this.fence = n2;
            this.threshold = n3;
            this.lo = n4;
            this.hi = n5;
        }

        @Override
        public final void compute() {
            int n;
            int n2;
            int[] nArray;
            IntBinaryOperator intBinaryOperator;
            block26: {
                block25: {
                    intBinaryOperator = this.function;
                    if (intBinaryOperator == null) break block25;
                    nArray = this.array;
                    if (this.array != null) break block26;
                }
                throw new NullPointerException();
            }
            int n3 = this.threshold;
            int n4 = this.origin;
            int n5 = this.fence;
            IntCumulateTask intCumulateTask = this;
            block0: while ((n2 = intCumulateTask.lo) >= 0 && (n = intCumulateTask.hi) <= nArray.length) {
                int n6;
                int n7;
                int n8;
                if (n - n2 > n3) {
                    IntCumulateTask intCumulateTask2;
                    IntCumulateTask intCumulateTask3 = intCumulateTask.left;
                    IntCumulateTask intCumulateTask4 = intCumulateTask.right;
                    if (intCumulateTask3 == null) {
                        n8 = n2 + n >>> 1;
                        intCumulateTask4 = intCumulateTask.right = new IntCumulateTask(intCumulateTask, intBinaryOperator, nArray, n4, n5, n3, n8, n);
                        intCumulateTask2 = intCumulateTask.right;
                        intCumulateTask3 = intCumulateTask.left = new IntCumulateTask(intCumulateTask, intBinaryOperator, nArray, n4, n5, n3, n2, n8);
                        intCumulateTask = intCumulateTask.left;
                    } else {
                        intCumulateTask3.in = n8 = intCumulateTask.in;
                        intCumulateTask = null;
                        intCumulateTask2 = null;
                        if (intCumulateTask4 != null) {
                            int n9;
                            n7 = intCumulateTask3.out;
                            int n10 = intCumulateTask4.in = n2 == n4 ? n7 : intBinaryOperator.applyAsInt(n8, n7);
                            while (((n9 = intCumulateTask4.getPendingCount()) & 1) == 0) {
                                if (!intCumulateTask4.compareAndSetPendingCount(n9, n9 | 1)) continue;
                                intCumulateTask = intCumulateTask4;
                                break;
                            }
                        }
                        while (((n7 = intCumulateTask3.getPendingCount()) & 1) == 0) {
                            if (!intCumulateTask3.compareAndSetPendingCount(n7, n7 | 1)) continue;
                            if (intCumulateTask != null) {
                                intCumulateTask2 = intCumulateTask;
                            }
                            intCumulateTask = intCumulateTask3;
                            break;
                        }
                        if (intCumulateTask == null) break;
                    }
                    if (intCumulateTask2 == null) continue;
                    intCumulateTask2.fork();
                    continue;
                }
                while (((n6 = intCumulateTask.getPendingCount()) & 4) == 0) {
                    int n11 = (n6 & 1) != 0 ? 4 : (n2 > n4 ? 2 : 6);
                    if (!intCumulateTask.compareAndSetPendingCount(n6, n6 | n11)) continue;
                    if (n11 != 2) {
                        int n12;
                        if (n2 == n4) {
                            n6 = nArray[n4];
                            n12 = n4 + 1;
                        } else {
                            n6 = intCumulateTask.in;
                            n12 = n2;
                        }
                        for (n8 = n12; n8 < n; ++n8) {
                            nArray[n8] = n6 = intBinaryOperator.applyAsInt(n6, nArray[n8]);
                        }
                    } else if (n < n5) {
                        n6 = nArray[n2];
                        for (int i = n2 + 1; i < n; ++i) {
                            n6 = intBinaryOperator.applyAsInt(n6, nArray[i]);
                        }
                    } else {
                        n6 = intCumulateTask.in;
                    }
                    intCumulateTask.out = n6;
                    while (true) {
                        IntCumulateTask intCumulateTask5;
                        if ((intCumulateTask5 = (IntCumulateTask)intCumulateTask.getCompleter()) == null) {
                            if ((n11 & 4) == 0) break block0;
                            intCumulateTask.quietlyComplete();
                            break block0;
                        }
                        n8 = intCumulateTask5.getPendingCount();
                        if ((n8 & n11 & 4) != 0) {
                            intCumulateTask = intCumulateTask5;
                            continue;
                        }
                        if ((n8 & n11 & 2) != 0) {
                            int n13;
                            IntCumulateTask intCumulateTask6;
                            IntCumulateTask intCumulateTask7 = intCumulateTask5.left;
                            if (intCumulateTask7 != null && (intCumulateTask6 = intCumulateTask5.right) != null) {
                                n13 = intCumulateTask7.out;
                                intCumulateTask5.out = intCumulateTask6.hi == n5 ? n13 : intBinaryOperator.applyAsInt(n13, intCumulateTask6.out);
                            }
                            if ((n7 = n8 | n11 | (n13 = (n8 & 1) == 0 && intCumulateTask5.lo == n4 ? 1 : 0)) != n8 && !intCumulateTask5.compareAndSetPendingCount(n8, n7)) continue;
                            n11 = 2;
                            intCumulateTask = intCumulateTask5;
                            if (n13 == 0) continue;
                            intCumulateTask5.fork();
                            continue;
                        }
                        if (intCumulateTask5.compareAndSetPendingCount(n8, n8 | n11)) break;
                    }
                    break block0;
                }
                break block0;
            }
        }
    }

    static final class LongCumulateTask
    extends CountedCompleter<Void> {
        final long[] array;
        final LongBinaryOperator function;
        LongCumulateTask left;
        LongCumulateTask right;
        long in;
        long out;
        final int lo;
        final int hi;
        final int origin;
        final int fence;
        final int threshold;

        public LongCumulateTask(LongCumulateTask longCumulateTask, LongBinaryOperator longBinaryOperator, long[] lArray, int n, int n2) {
            super(longCumulateTask);
            this.function = longBinaryOperator;
            this.array = lArray;
            this.lo = this.origin = n;
            this.hi = this.fence = n2;
            int n3 = (n2 - n) / (ForkJoinPool.getCommonPoolParallelism() << 3);
            this.threshold = n3 <= 16 ? 16 : n3;
        }

        LongCumulateTask(LongCumulateTask longCumulateTask, LongBinaryOperator longBinaryOperator, long[] lArray, int n, int n2, int n3, int n4, int n5) {
            super(longCumulateTask);
            this.function = longBinaryOperator;
            this.array = lArray;
            this.origin = n;
            this.fence = n2;
            this.threshold = n3;
            this.lo = n4;
            this.hi = n5;
        }

        @Override
        public final void compute() {
            int n;
            int n2;
            long[] lArray;
            LongBinaryOperator longBinaryOperator;
            block26: {
                block25: {
                    longBinaryOperator = this.function;
                    if (longBinaryOperator == null) break block25;
                    lArray = this.array;
                    if (this.array != null) break block26;
                }
                throw new NullPointerException();
            }
            int n3 = this.threshold;
            int n4 = this.origin;
            int n5 = this.fence;
            LongCumulateTask longCumulateTask = this;
            block0: while ((n2 = longCumulateTask.lo) >= 0 && (n = longCumulateTask.hi) <= lArray.length) {
                int n6;
                int n7;
                int n8;
                if (n - n2 > n3) {
                    LongCumulateTask longCumulateTask2;
                    LongCumulateTask longCumulateTask3 = longCumulateTask.left;
                    LongCumulateTask longCumulateTask4 = longCumulateTask.right;
                    if (longCumulateTask3 == null) {
                        n8 = n2 + n >>> 1;
                        longCumulateTask4 = longCumulateTask.right = new LongCumulateTask(longCumulateTask, longBinaryOperator, lArray, n4, n5, n3, n8, n);
                        longCumulateTask2 = longCumulateTask.right;
                        longCumulateTask3 = longCumulateTask.left = new LongCumulateTask(longCumulateTask, longBinaryOperator, lArray, n4, n5, n3, n2, n8);
                        longCumulateTask = longCumulateTask.left;
                    } else {
                        long l;
                        longCumulateTask3.in = l = longCumulateTask.in;
                        longCumulateTask = null;
                        longCumulateTask2 = null;
                        if (longCumulateTask4 != null) {
                            int n9;
                            long l2 = longCumulateTask3.out;
                            long l3 = longCumulateTask4.in = n2 == n4 ? l2 : longBinaryOperator.applyAsLong(l, l2);
                            while (((n9 = longCumulateTask4.getPendingCount()) & 1) == 0) {
                                if (!longCumulateTask4.compareAndSetPendingCount(n9, n9 | 1)) continue;
                                longCumulateTask = longCumulateTask4;
                                break;
                            }
                        }
                        while (((n7 = longCumulateTask3.getPendingCount()) & 1) == 0) {
                            if (!longCumulateTask3.compareAndSetPendingCount(n7, n7 | 1)) continue;
                            if (longCumulateTask != null) {
                                longCumulateTask2 = longCumulateTask;
                            }
                            longCumulateTask = longCumulateTask3;
                            break;
                        }
                        if (longCumulateTask == null) break;
                    }
                    if (longCumulateTask2 == null) continue;
                    longCumulateTask2.fork();
                    continue;
                }
                while (((n6 = longCumulateTask.getPendingCount()) & 4) == 0) {
                    int n10;
                    long l;
                    int n11 = (n6 & 1) != 0 ? 4 : (n2 > n4 ? 2 : 6);
                    if (!longCumulateTask.compareAndSetPendingCount(n6, n6 | n11)) continue;
                    if (n11 != 2) {
                        if (n2 == n4) {
                            l = lArray[n4];
                            n8 = n4 + 1;
                        } else {
                            l = longCumulateTask.in;
                            n8 = n2;
                        }
                        for (n10 = n8; n10 < n; ++n10) {
                            lArray[n10] = l = longBinaryOperator.applyAsLong(l, lArray[n10]);
                        }
                    } else if (n < n5) {
                        l = lArray[n2];
                        for (n8 = n2 + 1; n8 < n; ++n8) {
                            l = longBinaryOperator.applyAsLong(l, lArray[n8]);
                        }
                    } else {
                        l = longCumulateTask.in;
                    }
                    longCumulateTask.out = l;
                    while (true) {
                        LongCumulateTask longCumulateTask5;
                        if ((longCumulateTask5 = (LongCumulateTask)longCumulateTask.getCompleter()) == null) {
                            if ((n11 & 4) == 0) break block0;
                            longCumulateTask.quietlyComplete();
                            break block0;
                        }
                        n10 = longCumulateTask5.getPendingCount();
                        if ((n10 & n11 & 4) != 0) {
                            longCumulateTask = longCumulateTask5;
                            continue;
                        }
                        if ((n10 & n11 & 2) != 0) {
                            int n12;
                            LongCumulateTask longCumulateTask6;
                            LongCumulateTask longCumulateTask7 = longCumulateTask5.left;
                            if (longCumulateTask7 != null && (longCumulateTask6 = longCumulateTask5.right) != null) {
                                long l4 = longCumulateTask7.out;
                                longCumulateTask5.out = longCumulateTask6.hi == n5 ? l4 : longBinaryOperator.applyAsLong(l4, longCumulateTask6.out);
                            }
                            if ((n7 = n10 | n11 | (n12 = (n10 & 1) == 0 && longCumulateTask5.lo == n4 ? 1 : 0)) != n10 && !longCumulateTask5.compareAndSetPendingCount(n10, n7)) continue;
                            n11 = 2;
                            longCumulateTask = longCumulateTask5;
                            if (n12 == 0) continue;
                            longCumulateTask5.fork();
                            continue;
                        }
                        if (longCumulateTask5.compareAndSetPendingCount(n10, n10 | n11)) break;
                    }
                    break block0;
                }
                break block0;
            }
        }
    }
}

